<?php

/**
 * Plugin Name:       Digital Goods Checkout
 * Plugin URI:        http://www.wpcodelibrary.com/
 * Description:       Hide billing and shipping fields when only digital items are in cart.
 * Version:           1.0.0
 * Author:            wpcodelibrary
 * Author URI:        http://www.wpcodelibrary.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       digital-goods-checkout
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}


if ( ! class_exists( 'Digital_Goods_Checkout' ) ) {

	/**
	 * Plugin main class.
	 *
	 * @package Digital_Goods_Checkout
	 */
	class Digital_Goods_Checkout {

		/**
		 * Plugin version.
		 *
		 * @var string
		 */
		const VERSION = '1.0.0';

		/**
		 * Instance of this class.
		 *
		 * @var object
		 */
		protected static $instance = null;

		/**
		 * Initialize the plugin public actions.
		 */
		private function __construct() {
			add_action( 'init', array( $this, 'dgcfw_load_plugin_textdomain' ) );
			add_action( 'woocommerce_checkout_fields', array( $this, 'dgcfw_checkout_fields' ) );
		}

		/**
		 * Return an instance of this class.
		 *
		 * @return object A single instance of this class.
		 */
		public static function get_instance() {
			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * Load the plugin text domain for translation.
		 */
		public function dgcfw_load_plugin_textdomain() {
			load_plugin_textdomain( 'digital-goods-checkout', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
		}

		/**
		 * Check if cart contains only digital goods.
		 *
		 * @return bool
		 */
		protected function has_digital_goods_only() {
                        if ( WC()->cart && WC()->cart->needs_shipping()) {
                            return false;
                        }else {
                            return true;
                        }
			
		}

		/**
		 * Remove all billing fields when cart contains only digital goods.
		 *
		 * @param array $fields Checkout fields.
		 * @return array
		 */
		public function dgcfw_checkout_fields( $fields ) {
			if ( $this->has_digital_goods_only() ) {
				unset( $fields['billing']['billing_company'] );
				unset( $fields['billing']['billing_address_1'] );
				unset( $fields['billing']['billing_address_2'] );
				unset( $fields['billing']['billing_city'] );
				unset( $fields['billing']['billing_postcode'] );
				unset( $fields['billing']['billing_state'] );
				unset( $fields['billing']['billing_country'] );
				unset( $fields['billing']['billing_phone'] );
               	$fields['billing']['billing_email']['class'] = array( 'form-row-wide' );
			}

			return $fields;
		}

		
	}

	add_action( 'plugins_loaded', array( 'Digital_Goods_Checkout', 'get_instance' ) );

}
	add_filter('woocommerce_paypal_args','dgcfw_paypal_bn_code_filter', 99, 1);

		function dgcfw_paypal_bn_code_filter($paypal_args) {
            
            $paypal_args['bn'] = 'WPCodelibrary_SP_EC_PRO';
            return $paypal_args;
        }