<?php
add_action( 'widgets_init', create_function('', 'return register_widget("WCMP_PLAYLIST_WIDGET");') );	 

if( !class_exists( 'WCMP_PLAYLIST_WIDGET' ) )
{
	class WCMP_PLAYLIST_WIDGET extends WP_Widget
	{
		function __construct()
		{
			$widget_ops = array('classname' => 'WCMP_PLAYLIST_WIDGET', 'description' => 'Includes a playlist with the audio files of products selected' );
			
			parent::__construct('WCMP_PLAYLIST_WIDGET', 'Music Player for WooCommerce - Playlist', $widget_ops);
		}

		function form($instance)
		{
			$instance = wp_parse_args( (array) $instance, array( 'title' => '', 'products_ids' => '', 'highlight_current_product' => 0, 'continue_playing' => 0, 'player_style' => WCMP_DEFAULT_PLAYER_LAYOUT, 'file_name' => 0 ) );
	
			$title 						= $instance['title'];
			$products_ids 				= $instance['products_ids'];    
			$highlight_current_product 	= $instance['highlight_current_product'];    
			$continue_playing 			= $instance['continue_playing'];    
			$player_style 				= $instance['player_style'];    
			$file_name 					= $instance['file_name'];    
			
			?>
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e( 'Title', 'woocommerce_music_player' ); ?>: <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></label>
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('products_ids'); ?>"><?php _e( 'Products IDs', 'woocommerce_music_player' ); ?>: <input class="widefat" id="<?php echo $this->get_field_id('products_ids'); ?>" name="<?php echo $this->get_field_name('products_ids'); ?>" type="text" value="<?php echo esc_attr($products_ids); ?>" placeholder="<?php _e( 'Products IDs separated by comma, or a * for all', 'woocommerce_music_player' ); ?>" /></label>
			</p>
			<p>
				<?php
					_e( 'Enter the ID of products separated by comma, or a * symbol to includes all products in the playlist.', 'woocommerce_music_player' );
				?>
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('player_style'); ?>"><?php _e( 'Player layout', 'woocommerce_music_player' ); ?>: </label>
			</p>
			<p>
				<label><input name="<?php echo $this->get_field_name('player_style'); ?>" type="radio" value="mejs-classic" <?php echo (($player_style == 'mejs-classic') ? 'checked' : '') ;?> style="float:left; margin-top:8px;" /><img src="<?php print esc_url(WCMP_PLUGIN_URL); ?>/views/assets/skin1_btn.png" /></label>
			</p>
			<p>
				<label><input name="<?php echo $this->get_field_name('player_style'); ?>" type="radio" value="mejs-ted" <?php echo (($player_style == 'mejs-ted') ? 'checked' : '') ;?> style="float:left; margin-top:8px;" /><img src="<?php print esc_url(WCMP_PLUGIN_URL); ?>/views/assets/skin2_btn.png" /></label>
			</p>
			<p>
				<label><input name="<?php echo $this->get_field_name('player_style'); ?>" type="radio" value="mejs-wmp" <?php echo (($player_style == 'mejs-wmp') ? 'checked' : '') ;?> style="float:left; margin-top:16px;" /><img src="<?php print esc_url(WCMP_PLUGIN_URL); ?>/views/assets/skin3_btn.png" /></label>
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('file_name'); ?>"><?php _e( 'Display file name', 'woocommerce_music_player' ); ?>: <input id="<?php echo $this->get_field_id('file_name'); ?>" name="<?php echo $this->get_field_name('file_name'); ?>" type="checkbox" <?php echo ( ( $file_name ) ? 'CHECKED' : '' ); ?> /></label>
			</p>
			<p>
				<?php
					_e( 'Display the files names if the checkbox is ticked, or the products names if not.', 'woocommerce_music_player' );
				?>
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('highlight_current_product'); ?>"><?php _e( 'Highlight the current product', 'woocommerce_music_player' ); ?>: <input id="<?php echo $this->get_field_id('highlight_current_product'); ?>" name="<?php echo $this->get_field_name('highlight_current_product'); ?>" type="checkbox" <?php echo ( ( $highlight_current_product ) ? 'CHECKED' : '' ); ?> /></label>
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('continue_playing'); ?>"><?php _e( 'Continue playing after navigate', 'woocommerce_music_player' ); ?>: <input id="<?php echo $this->get_field_id('continue_playing'); ?>" name="<?php echo $this->get_field_name('continue_playing'); ?>" type="checkbox" <?php echo ( ( $continue_playing ) ? 'CHECKED' : '' ); ?> /></label>
			</p>
			<p>
				<?php
					_e( 'Continue playing the same song at same position after navigate. You can experiment some delay because the music player should to load the audio file again, and in some mobiles devices, where the action of the user is required, the player cannot starting playing automatically.', 'woocommerce_music_player' );
				?>
			</p>
			<?php
		}

		function update($new_instance, $old_instance)
		{
			$instance = $old_instance;
			$instance['title'] = $new_instance['title'];
			$instance['products_ids'] = $new_instance['products_ids'];
			$instance['highlight_current_product'] = $new_instance['highlight_current_product'];
			$instance['continue_playing'] = $new_instance['continue_playing'];
			$instance['player_style'] = $new_instance['player_style'];
			$instance['file_name'] = $new_instance['file_name'];
			
			return $instance;
		}

		function widget($args, $instance)
		{
			extract($args, EXTR_SKIP);

			$title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
			$products_ids 				= $instance['products_ids'];    
			$highlight_current_product 	= $instance['highlight_current_product'];    
			$continue_playing 			= $instance['continue_playing'];
			$player_style 				= $instance['player_style'];
			$file_name 					= $instance['file_name'];
			
			// get the produts ids
			$products_ids = preg_replace( '/[^\d\,\*]/', '', $products_ids);
			$products_ids = preg_replace( '/(\,\,)+/', '', $products_ids);
			$products_ids = trim($products_ids, ',');
			
			if( strlen( $products_ids ) == 0 ) return;
			
			echo $before_widget;
			if (!empty($title))
				echo $before_title . $title . $after_title;
			
			// WIDGET CODE GOES HERE    
			global $wpdb, $post;
			
			$current_post_id = ( !empty( $post ) ) ? $post->ID : -1;
			
			$query = 'SELECT posts.ID, posts.post_title FROM '.$wpdb->posts.' AS posts, '.$wpdb->postmeta.' as postmeta WHERE posts.post_status="publish" AND posts.post_type="product" AND posts.ID = postmeta.post_id AND postmeta.meta_key="_wcmp_enable_player" AND (postmeta.meta_value="yes" OR postmeta.meta_value="1")';
			
			if( strpos( '*', $products_ids ) === false ) 
			{
				$query .= ' AND posts.ID IN ('.$products_ids.')';
			}	
				
			
			$query .= ' ORDER BY posts.post_title ASC';
			
			$products = $wpdb->get_results( $query );
			if( !empty( $products ) )
			{
				// Enqueue resources
				$GLOBALS[ 'WooCommerceMusicPlayer' ]->enqueue_resources();
				wp_enqueue_style( 'wcmp-playlist-widget-style', plugin_dir_url(__FILE__).'playlist_widget/css/style.css' );
				wp_enqueue_script( 'wcmp-playlist-widget-script', plugin_dir_url(__FILE__).'playlist_widget/js/public.js' );
				
				$counter = 0;
				foreach( $products as $product )
				{
					$counter++;
					$class = 'wcmp-even-product';
					if( $counter%2 == 1) $class = 'wcmp-odd-product';
					
					echo '<ul class="wcmp-widget-playlist '.esc_attr( $class ).' '.esc_attr( ( $product->ID == $current_post_id ) ? 'wcmp-current-product' : '' ).'">';
					$audio_files = $GLOBALS[ 'WooCommerceMusicPlayer' ]->get_product_files( $product->ID );
					foreach( $audio_files as $index => $file )
					{
						$audio_url = $GLOBALS[ 'WooCommerceMusicPlayer' ]->generate_audio_url( $product->ID,  $index );
						echo '<li class="wcmp-widget-playlist-item">'.$GLOBALS[ 'WooCommerceMusicPlayer' ]->get_player( $audio_url, array( 'player_controls' => 'track', 'player_style' => $player_style, 'media_type' => $file[ 'media_type' ], 'id' => $index ) ).'<a href="'.esc_url( get_permalink( $product->ID ) ).'">'.esc_html( ( !empty( $file_name ) ) ? $file[ 'name' ] : $product->post_title ).'</a></li>';
					}
					echo '</ul>';
				}
			}	
			//echo cp_calculatedfieldsf_filter_content( array( 'id' => $formid ) );

			echo $after_widget;
		}
	} // End Class WCMP_PLAYLIST_WIDGET
}	
?>