<?php
	$iron_soundrise_page_id = Iron_soundrise::getOption('404_page_selection');
	get_header();
?>
	<!-- container -->
	<div class="container">
		<div class="content__wrapper <?php echo esc_attr( ( $iron_soundrise_page_id ) ? '': 'boxed' ) ?>">
			<!-- single-post -->
			<article class="sr_it-single-post">
				<div class="entry">
					<div class="<?php echo esc_attr( ( Iron_soundrise::isPageTitleUppercase() ) ? 'uppercase' : '' ) ?>">
						<span class="heading-t"></span>
						<h1><?php esc_html( Iron_soundrise::displayPageTitle( $iron_soundrise_page_id, esc_html__('Page not found', 'soundrise') ) ); ?></h1>
						<?php Iron_soundrise::displayPageTitleDivider(); ?>
					</div>
					<?php if( $iron_soundrise_page_id ){
						echo wp_kses_post( apply_filters( 'the_content', get_post_field( 'post_content', $iron_soundrise_page_id) ) );
					}else{ // Default content ?>
						<p><?php echo esc_html__('Are you lost? The content you were looking for is not here.','soundrise'); ?></p>
						<p>
							<a href="<?php echo esc_url( get_home_url( null, '/' ) ) ?>">
								<?php echo esc_html__('Return to home page', 'soundrise'); ?>
							</a>
						</p>
					<?php } ?>
				</div>
			</article>
		</div>
	</div>

	<?php get_footer(); ?>