<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, height=device-height, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
	<?php wp_head(); ?>
</head>
<body <?php body_class() ?>>
	<div id="overlay"><div class="perspective"></div></div>
	<?php
	$iron_soundrise_fixed_header = Iron_soundrise::getOption('enable_fixed_header', null, '0');
	$iron_soundrise_menu_type = Iron_soundrise::getOption('menu_type', null, 'push-menu');
	$iron_soundrise_menu_position = Iron_soundrise::getOption('classic_menu_position', null, 'absolute absolute_before');
	$iron_soundrise_menu_is_over = Iron_soundrise::getField('classic_menu_over_content', get_the_ID());
	$iron_soundrise_menu_icon_toggle = (int)Iron_soundrise::getOption('header_menu_toggle_enabled', null, 1);

	if(!empty($iron_soundrise_menu_is_over)) {
		$iron_soundrise_menu_position = ($iron_soundrise_menu_position == 'absolute absolute_before') ? 'absolute' : 'fixed';
	}

	if($iron_soundrise_menu_type == 'push-menu'){
		get_template_part('parts/push', 'menu');
	}

	if($iron_soundrise_menu_type == 'classic-menu' && $iron_soundrise_menu_position != 'absolute' && $iron_soundrise_menu_position != 'absolute absolute_before'){
		get_template_part('parts/classic', 'menu');
	}

	if($iron_soundrise_menu_type == 'push-menu'): ?>
		<header class="opacityzero">
			<?php if( $iron_soundrise_menu_icon_toggle !== 0):?>
			<div class="menu-toggle <?php echo ($iron_soundrise_menu_icon_toggle == 2)? 'hidden-on-desktop':'' ?>">
					<span class="svgfill"></span>
					<span class="svgfill"></span>
					<span class="svgfill"></span>
			</div>
			<?php endif ?>
			<?php get_template_part('parts/top-menu'); ?>

			<?php if( Iron_soundrise::getOption('header_logo', null, get_template_directory_uri().'/images/logo.png') !== ''): ?>
				<a href="<?php echo esc_url( home_url('/'));?>" class="site-logo" title="<?php echo esc_attr( get_bloginfo('name') ); ?>">

					<?php
						$logoPageSelectVersion = ( !is_archive() && ( Iron_soundrise::getField('page_logo_select', get_the_ID() ) !== 'null' && Iron_soundrise::getField('page_logo_select', get_the_ID() ) !== '' ) )? Iron_soundrise::getField('page_logo_select', get_the_ID() ) : '';
						$logoSelectVersion = ( $logoPageSelectVersion )? $logoPageSelectVersion : Iron_soundrise::getOption('header_logo_select', null, 'dark');



					if( $logoSelectVersion == 'light' ){
						$iron_soundrise_logo1x = Iron_soundrise::getOption('header_alternative_logo', null, get_template_directory_uri().'/images/logo.png');
						$iron_soundrise_logo2x = Iron_soundrise::getOption('retina_header_alternative_logo', null, get_template_directory_uri().'/images/logo@2x.png');
					}else{
						$iron_soundrise_logo1x = Iron_soundrise::getOption('header_logo', null, get_template_directory_uri().'/images/logo.png');
						$iron_soundrise_logo2x = Iron_soundrise::getOption('retina_header_logo', null, get_template_directory_uri().'/images/logo@2x.png');

					} ?>
					<img id="menu-trigger" class="logo-desktop regular" src="<?php echo esc_url( $iron_soundrise_logo1x ); ?>" <?php echo ($iron_soundrise_logo2x)? 'srcset="' . esc_url( $iron_soundrise_logo1x ) . ' 1x,' . esc_url( $iron_soundrise_logo2x ) . ' 2x"' : ''?> alt="<?php echo esc_attr( get_bloginfo('name') ); ?>">
				</a>
			<?php endif; ?>

		</header>
	<?php endif;?>

	<div id="pusher-wrap">

		<div id="pusher" class="menu-type-<?php echo esc_attr($iron_soundrise_menu_type);?>">
	<?php

	if($iron_soundrise_menu_type == 'classic-menu' && ($iron_soundrise_menu_position == 'absolute' || $iron_soundrise_menu_position == 'absolute absolute_before') ){

		get_template_part('parts/classic', 'menu');
	} ?>
	<div class="pjax-container">
	<div id="wrapper" class="wrapper">

	<?php
	if( function_exists('is_shop') && is_shop() ){
		$post_id = wc_get_page_id('shop');
	}else{
		$post_id = $post->ID;
	}
	$banner_background_type = Iron_soundrise::getField('banner_background_type', $post_id);
	$banner_typeCSS = ($banner_background_type !== 'null' && $banner_background_type !== '')? '' : 'no-banner' ;

	if ($banner_background_type !== 'null' && $banner_background_type !== '') {
		get_template_part('parts/page-banner');
	}
	?>