/*! Copyright 2013 Adobe Systems Inc.;
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at

* http://www.apache.org/licenses/LICENSE-2.0

* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
Gradient Maps support
Author: Alan Greenblatt (blatt@adobe.com, @agreenblatt, blattchat.com)
*/
function clamp_css_byte(a){return a=Math.round(a),0>a?0:a>255?255:a}function clamp_css_float(a){return 0>a?0:a>1?1:a}function parse_css_int(a){return clamp_css_byte("%"===a[a.length-1]?parseFloat(a)/100*255:parseInt(a))}function parse_css_float(a){return clamp_css_float("%"===a[a.length-1]?parseFloat(a)/100:parseFloat(a))}function css_hue_to_rgb(a,b,c){return 0>c?c+=1:c>1&&(c-=1),1>6*c?a+(b-a)*c*6:1>2*c?b:2>3*c?a+(b-a)*(2/3-c)*6:a}function parseCSSColor(a){var b=a.replace(/ /g,"").toLowerCase();if(b in kCSSColorTable)return kCSSColorTable[b].slice();if("#"===b[0]){if(4===b.length){var c=parseInt(b.substr(1),16);return c>=0&&4095>=c?[(3840&c)>>4|(3840&c)>>8,240&c|(240&c)>>4,15&c|(15&c)<<4,1]:null}if(7===b.length){var c=parseInt(b.substr(1),16);return c>=0&&16777215>=c?[(16711680&c)>>16,(65280&c)>>8,255&c,1]:null}return null}var d=b.indexOf("("),e=b.indexOf(")");if(-1!==d&&e+1===b.length){var f=b.substr(0,d),g=b.substr(d+1,e-(d+1)).split(","),h=1;switch(f){case"rgba":if(4!==g.length)return null;h=parse_css_float(g.pop());case"rgb":return 3!==g.length?null:[parse_css_int(g[0]),parse_css_int(g[1]),parse_css_int(g[2]),h];case"hsla":if(4!==g.length)return null;h=parse_css_float(g.pop());case"hsl":if(3!==g.length)return null;var i=(parseFloat(g[0])%360+360)%360/360,j=parse_css_float(g[1]),k=parse_css_float(g[2]),l=.5>=k?k*(j+1):k+j-k*j,m=2*k-l;return[clamp_css_byte(255*css_hue_to_rgb(m,l,i+1/3)),clamp_css_byte(255*css_hue_to_rgb(m,l,i)),clamp_css_byte(255*css_hue_to_rgb(m,l,i-1/3)),h];default:return null}}return null}window.GradientMaps=function(a){function b(){this.init()}return b.prototype={init:function(){},generateID:function(){return this.previousID=this.previousID+1||0,this.previousID},calcStopsArray:function(a){var b=a.match(/(((rgb|hsl)a?\(\d{1,3},\s*\d{1,3},\s*\d{1,3}(?:,\s*0?\.?\d+)?\)|\w+|#[0-9a-fA-F]{1,6})(\s+(0?\.\d+|\d{1,3}%))?)/g),c=(a.split(","),[]);if(b.forEach(function(a){var b=a.match(/(?:((rgb|hsl)a?\(\d{1,3},\s*\d{1,3},\s*\d{1,3}(?:,\s*0?\.?\d+)?\)|\w+|#[0-9a-fA-F]{1,6})(\s+(?:0?\.\d+|\d{1,3}%))?)/);b&&b.length>=4&&(posMatch=b[3],c.push({color:parseCSSColor(b[1]),pos:posMatch?100*parse_css_float(posMatch):null}))}),c.length>=1){var d=c[0];d.pos?d.pos=Math.min(100,Math.max(0,d.pos)):d.pos=0;var e=d.pos;d=c[c.length-1],d.pos?d.pos=Math.min(100,Math.max(0,d.pos)):d.pos=100;for(var f=1;f<c.length-1;f++)d=c[f],d.pos&&d.pos<e&&(d.pos=e),d.pos>100&&(d.pos=100),e=d.pos;for(var f=1;f<c.length-1;){if(!c[f].pos){for(var g=f+1;g<c.length&&!c[g].pos;g++);for(var h=c[f-1].pos,i=c[g].pos,j=g-1+1,k=Math.round((i-h)/j);g>f;)c[f].pos=c[f-1].pos+k,f++}f++}0!=c[0].pos&&c.unshift({color:c[0].color,pos:0}),100!=c[c.length-1].pos&&c.push({color:c[c.length-1].color,pos:100})}return c},findMatchingDistributedNSegs:function(a){for(var b=100,c=!1,d=1;!c&&b>=d;d++){var e=b/d;c=!0;for(var f=1;f<a.length-1;f++){var g=a[f].pos;if(e>g){c=!1;break}var h=g%e,i=1;if(!(i>h||i>e-h)){c=!1;break}}if(c)return d}return d},calcDistributedColors:function(a,b){for(var c=[a[0].color],d=100/b,e=1;e<a.length-1;e++){var f=a[e],g=Math.round(f.pos/d);c[g]=f.color}c[b]=a[a.length-1].color;for(var e=1;e<c.length;){if(!c[e]){for(var h=e+1;h<c.length&&!c[h];h++);for(var i=c[e-1],j=i[0],k=i[1],l=i[2],m=i[3],n=c[h],b=h-e+1,o=(n[0]-j)/b,p=(n[1]-k)/b,q=(n[2]-l)/b,r=(n[3]-m)/b;h>e;)j+=o,k+=p,l+=q,m+=r,c[e]=[j,k,l,m],e++}e++}return c},addElement:function(a,b,c,d,e){var f=d?a.createElementNS(d,c):a.createElement(c);return e&&Object.keys(e).forEach(function(a,b,c){f.setAttribute(a,e[a])}),b&&b.appendChild(f),f},addSVGComponentTransferFilter:function(a,b){var c=null,d=null,e="http://www.w3.org/2000/svg",f=a.getAttribute("data-gradientmap-filter"),g=!1,h=a.ownerDocument;if(f&&(c=h.getElementById(f))){var i=c.getElementsByTagNameNS(e,"feComponentTransfer");if(i){for(var j=i.length-1;j>=0;--j)c.removeChild(i[j]);d=c.parentElement}}if(!d){var d=this.addElement(h,null,"svg",e,{version:"1.1",width:0,height:0});f="filter-"+this.generateID(),c=this.addElement(h,d,"filter",e,{id:f}),a.setAttribute("data-gradientmap-filter",f);this.addElement(h,c,"feColorMatrix",e,{type:"matrix",values:"0.2126 0.7152 0.0722 0 0 0.2126 0.7152 0.0722 0 0 0.2126 0.7152 0.0722 0 0 0 0 0 1 0",result:"gray"});g=!0}var k=this.addElement(h,c,"feComponentTransfer",e,{"color-interpolation-filters":"sRGB"}),l="",m="",n="",o="";b.forEach(function(a,b,c){l+=a[0]/255+" ",m+=a[1]/255+" ",n+=a[2]/255+" ",o+=a[3]+" "}),this.addElement(h,k,"feFuncR",e,{type:"table",tableValues:l.trim()}),this.addElement(h,k,"feFuncG",e,{type:"table",tableValues:m.trim()}),this.addElement(h,k,"feFuncB",e,{type:"table",tableValues:n.trim()}),this.addElement(h,k,"feFuncA",e,{type:"table",tableValues:o.trim()}),g&&a.parentElement.insertBefore(d,a);var p="url(#"+f+")";a.style["-webkit-filter"]=p,a.style.filter=p},applyGradientMap:function(a,b){var c=this.calcStopsArray(b),d=this.findMatchingDistributedNSegs(c),e=this.calcDistributedColors(c,d);this.addSVGComponentTransferFilter(a,e)},removeGradientMap:function(a){var b=a.getAttribute("data-gradientmap-filter");if(b){var c=a.ownerDocument,d=c.getElementById(b);if(d){var e=d.parentElement;if(e.removeChild(d),e.childNodes.length<=0){var f=e.parentElement;f.removeChild(e)}}a.removeAttribute("data-gradientmap-filter"),a.style["-webkit-filter"]="",a.style.filter=""}}},new b}(window);var kCSSColorTable={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};try{exports.parseCSSColor=parseCSSColor}catch(e){}