<?php

	$iron_soundrise_post_id = get_the_ID();

	if(is_home() && get_option('page_for_posts') != '') {

		$iron_soundrise_post_id = get_option('page_for_posts');

	}else if(is_front_page() && get_option('page_on_front') != '') {

		$iron_soundrise_post_id = get_option('page_on_front');

	}else if(function_exists('is_shop') && is_shop() && get_option('woocommerce_shop_page_id') != '') {

		$iron_soundrise_post_id = get_option('woocommerce_shop_page_id');

	}elseif($wp_query && !empty($wp_query->queried_object) && !empty($wp_query->queried_object->ID)) {

		$iron_soundrise_post_id = $wp_query->queried_object->ID;
	}


	$iron_soundrise_menu_position = Iron_soundrise::getOption('classic_menu_position', null, 'absolute absolute_before');
	$iron_soundrise_menu_logo_align = Iron_soundrise::getOption('classic_menu_logo_align', null, 'pull-left');
	$iron_soundrise_classic_menu_over_content = Iron_soundrise::getField('classic_menu_over_content', $iron_soundrise_post_id );
	if(!empty( $iron_soundrise_classic_menu_over_content )) {
		if($iron_soundrise_menu_position == 'absolute absolute_before') {
			$iron_soundrise_menu_position = 'absolute';
		}else{
			$iron_soundrise_menu_position = 'fixed';
		}
	}

	$iron_soundrise_container_classes = array();
	$iron_soundrise_container_classes[] = 'classic-menu';
	$iron_soundrise_container_classes[] = Iron_soundrise::getOption('classic_menu_effect', null, 'reset');
	$iron_soundrise_container_classes[] = $iron_soundrise_menu_position;


	$iron_soundrise_menu_classes = array();
	$iron_soundrise_menu_classes[] = 'menu-level-0';
	$iron_soundrise_menu_classes[] = Iron_soundrise::getOption('classic_menu_align', null, 'pull-center');
	$iron_soundrise_menu_classes[] = Iron_soundrise::getOption('classic_menu_width', null, 'fullwidth');
 	$iron_soundrise_alternative_logo = Iron_soundrise::getField('alternative_logo', $iron_soundrise_post_id );
 	$iron_alternative_logo = $iron_alternative_logo_retina = $iron_use_alternative_logo = '';
	if(!empty( $iron_soundrise_alternative_logo )) {
		$iron_use_alternative_logo = 1;
		$iron_alternative_logo = Iron_soundrise::getOption('header_alternative_logo');
		$iron_alternative_logo_retina = Iron_soundrise::getOption('retina_header_alternative_logo');
	}

	$iron_use_alternative_logo_on_mobile = Iron_soundrise::getOption('use_alternative_logo_on_mobile');

	if($iron_use_alternative_logo_on_mobile==1){
		$iron_alternative_logo = Iron_soundrise::getOption('header_alternative_logo');
		$iron_alternative_logo_retina = Iron_soundrise::getOption('retina_header_alternative_logo');
	}



	if($iron_soundrise_menu_logo_align == 'pull-top')
		$iron_soundrise_menu_classes[] = 'logo-pull-top';

?>

<div class="<?php echo esc_attr( implode(" ", $iron_soundrise_container_classes) ); ?>">
	<?php

	echo wp_nav_menu( array(
		'menu_id' => 'menu-main-menu',
		'container' => false,
		'theme_location' => 'main-menu',
		'menu_class' => implode(" ", $iron_soundrise_menu_classes),
		'echo' => false,
		'fallback_cb' => '__return_false'
	));

	$iron_soundrise_menu_items = Iron_soundrise::getOption('header_top_menu', null, array(
					0 => array(
						'menu_page_name' => '',
						'menu_page_is_menu' => '',
						'menu_page_url' => '',
						'pages_select' => '',
						'menu_page_external_url' => '',
						'menu_page_icon' => '',
						'order_no'     => 1
					),
				));
	?>

	<!-- social-networks -->
	<ul class="classic-menu-hot-links <?php echo esc_attr( (!empty($_GET["mpos"]) ? $_GET["mpos"] : Iron_soundrise::getOption('menu_position', null, 'righttype') ) ) ?>">

		<?php if((bool)Iron_soundrise::getOption('header_top_menu_enabled', null, false) && !empty($iron_soundrise_menu_items)): 
			
			foreach($iron_soundrise_menu_items as $item):
				if(!empty($item["menu_page_external_url"])) {
					$iron_soundrise_url = $item["menu_page_external_url"];
				}else{
					$iron_soundrise_url = get_permalink($item["menu_page_url"]);
				}
				$iron_soundrise_target = $item["menu_page_url_target"];
				$iron_soundrise_hide_page_name = !empty($item["menu_hide_page_title"]) ? (bool)$item["menu_hide_page_title"] : false;
				?>
				<li class="hotlink pull-right">
					<a target="<?php echo esc_attr($iron_soundrise_target);?>" href="<?php echo esc_url($iron_soundrise_url); ?>">
						<?php if(!empty($item["menu_page_icon"])): ?>
							<?php 	if( substr($item["menu_page_icon"],0,4) != 'fab ' && substr($item["menu_page_icon"],0,4) != 'far ' && substr($item["menu_page_icon"],0,4) != 'fas ' && substr($item["menu_page_icon"],0,3) != 'fa '){
								$item["menu_page_icon"] = 'fa  fa-'.$item["menu_page_icon"];
							}?>
							<i class="<?php echo esc_attr($item["menu_page_icon"]); ?>" title="<?php echo esc_attr($item["menu_page_name"]); ?>"></i>
						<?php endif;?>

						<?php if(!$iron_soundrise_hide_page_name): ?>
							<?php echo esc_html($item["menu_page_name"]); ?>
						<?php endif; ?>

						<?php if(function_exists('is_shop')): ?>

							<?php global $woocommerce; ?>


							<?php if (!empty($item["menu_page_url"]) && (get_option('woocommerce_cart_page_id') == $item["menu_page_url"]) && $woocommerce->cart->cart_contents_count > 0): ?>

								<span>( <?php echo esc_html($woocommerce->cart->cart_contents_count);?> )</span>

							<?php endif; ?>

						<?php endif; ?>
					</a>

				</li>
			<?php endforeach; ?>
		<?php endif; ?>
		<li class="languages-selector hotlink pull-right">
			<?php dynamic_sidebar( 'soundrise_sidebar_lang' ) ?>
		</li>
	</ul>
	<div class="clear"></div>

	

</div>
