<?php
// Template Name: Blank layout
// Template Post Type: artist

get_header();

global $post;

$iron_soundrise_artist_featured_album = ( get_field('artist_hero_playlist') == 'null' )? false : get_field('artist_hero_playlist') ;
$iron_soundrise_single_post_featured_image = Iron_soundrise::getField('single_post_featured_image', $post->ID);
$iron_soundrise_show_post_date = (bool)Iron_soundrise::getOption('show_post_date', null, true);
$iron_soundrise_show_post_author = (bool)Iron_soundrise::getOption('show_post_author', null, true);
$iron_soundrise_show_post_categories = (bool)Iron_soundrise::getOption('show_post_categories', null, true);
$iron_soundrise_show_post_tags = (bool)Iron_soundrise::getOption('show_post_tags', null, true);


/**
 * Setup Dynamic Sidebar
 */

list( $iron_soundrise_has_sidebar, $iron_soundrise_sidebar_position, $iron_soundrise_sidebar_area ) = Iron_soundrise::setupDynamicSidebar( $post->ID ); ?>

		<!-- container -->
		<div class="container">
		<div class="boxed">

<?php if ( have_posts() ) :
	while ( have_posts() ) : the_post();
		$iron_soundrise_single_title = ( Iron_soundrise::getOption('single_post_page_title') );
		if(!empty($iron_soundrise_single_title)): ?>
			<div class="page-title <?php (Iron_soundrise::isPageTitleUppercase() == true) ? 'uppercase' : '';?>">
				<span class="heading-t"></span>
				<h1><?php echo esc_html($iron_soundrise_single_title); ?></h1>
				<?php Iron_soundrise::displayPageTitleDivider(); ?>
			</div>
		<?php endif;

		if ( $iron_soundrise_has_sidebar ) : ?>
			<div id="twocolumns" class="content__wrapper<?php if ( 'left' === $iron_soundrise_sidebar_position ) echo ' content--rev'; ?>">
				<div id="content" class="content__main">
		<?php endif; ?>

		<!-- single-post -->
		<article id="post-<?php the_ID(); ?>" <?php post_class( $banner_typeCSS ); ?>>
			<?php
			if(!empty($iron_soundrise_single_title)):
				$headerSize = 'h2';
			else:
				$headerSize = 'h1';
			endif;


			if( Iron_soundrise::getField( 'hide_page_title', $post->ID ) != '1' ){
				the_title('<' . $headerSize . ' class="sr_it-singlepost-title">','</' . $headerSize . '>');
			}
			if (!$banner_background_type) {

				if($iron_soundrise_single_post_featured_image == 'original') {
					the_post_thumbnail( 'large' , array( 'class' => 'wp-featured-image original' ) );
				}else{
					the_post_thumbnail( 'large' , array( 'class' => 'wp-featured-image fullwidth' ) );
				}
			}?>


			<div class="entry">

			<?php if($iron_soundrise_artist_featured_album):?>
			<div class="artist_player" data-url-playlist="<?php echo esc_url(home_url('?load=playlist.json&amp;albums='.$iron_soundrise_artist_featured_album.''))?>" >

			    <div class="playerNowPlaying">
			        <div class="album-art">
			            <img src=""/>
			        </div>
			        <div class="metadata">
			            <div class="track-name"></div>
			            <div class="album-title"></div>
			        </div>
			    </div>
			    <div class="player">
			    <div class="progressLoading"></div>
			    <div id="artistPlayer" class="wave"></div>

			    <div class="control">
			            <div class="previous">
			                <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 10.2 11.7" style="enable-background:new 0 0 10.2 11.7;" xml:space="preserve">
								<polygon points="10.2,0 1.4,5.3 1.4,0 0,0 0,11.7 1.4,11.7 1.4,6.2 10.2,11.7"></polygon>
							</svg>
			            </div>
			            <div class="play">
			                <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 17.5 21.2" style="enable-background:new 0 0 17.5 21.2;" xml:space="preserve">
								<path d="M0,0l17.5,10.9L0,21.2V0z"></path>

								<rect width="6" height="21.2"></rect>
								<rect x="11.5" width="6" height="21.2"></rect>
							</svg>
			            </div>
			            <div class="next">
			                <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 10.2 11.7" style="enable-background:new 0 0 10.2 11.7;" xml:space="preserve">
								<polygon points="0,11.7 8.8,6.4 8.8,11.7 10.2,11.7 10.2,0 8.8,0 8.8,5.6 0,0"></polygon>
							</svg>
			            </div>
			        </div>
			    </div>
			    <div class="playlist"></div>
			</div>
			<?php endif ?>
				<?php the_content(); ?>
				<?php wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'soundrise' ), 'after' => '</span></div>', 'link_before' => '<span>', 'link_after' => '</span>' ) ); ?>
			</div>
		</article>

		<?php

		if ( $iron_soundrise_has_sidebar ) : ?>
		</div>
			<aside id="sidebar" class="sr_it-content-side widget-area widget-area--<?php echo esc_attr( $iron_soundrise_sidebar_area ); ?>">
			<?php
				do_action('before_ironband_sidebar_dynamic_sidebar', 'single-post.php');

				dynamic_sidebar( $iron_soundrise_sidebar_area );

				do_action('after_ironband_sidebar_dynamic_sidebar', 'single-post.php');
			?>
			</aside>
			</div>
<?php 	endif;

	endwhile;
endif;
?>

		</div>
		</div>
<?php get_footer(); ?>