<?php get_header(); ?>

		<div class="container">
		<div class="boxed">

		<?php
		if ( have_posts() ) :
			while ( have_posts() ) : the_post();
		?>

		<?php
		$iron_soundrise_single_title = Iron_soundrise::getOption('single_event_page_title');
		if(!empty($iron_soundrise_single_title)):
		?>
			<div class="page-title <?php (Iron_soundrise::isPageTitleUppercase() == true) ? 'uppercase' : '';?>">
			<span class="heading-t"></span>
				<h1><?php echo esc_html($iron_soundrise_single_title); ?></h1>
			<?php Iron_soundrise::displayPageTitleDivider(); ?>
		</div>

		<?php endif; ?>

		<?php
		list( $iron_soundrise_has_sidebar, $iron_soundrise_sidebar_position, $iron_soundrise_sidebar_area ) = Iron_soundrise::setupDynamicSidebar( $post->ID );

		if ( $iron_soundrise_has_sidebar ) :
?>
			<div id="twocolumns" class="content__wrapper<?php if ( 'left' === $iron_soundrise_sidebar_position ) echo ' content--rev'; ?>">
				<div id="content" class="content__main">
<?php
		endif;
?>


			<!-- single-post -->
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<div class="entry">
					<div class="event-wrapper">
					<?php
					if ( has_post_thumbnail() ) {
					?>
						<div class="lefthalf">
							<?php the_post_thumbnail('full'); ?>
						</div>
					<?php
					};
					?>
						<div class="righthalf">
							<?php if( Iron_soundrise::getField( 'hide_page_title', $post->ID ) != '1' ):?>
							<div class="event-boldtitle"><?php the_title(); ?><br></div>
							<?php endif ?>
							<table>
								<?php if( function_exists('get_artists') ): ?>
								<?php if( get_artists($post->ID, $post->post_type) ): ?>
								<tr>
									<td class="event-icon"><i class="fa fa-user"></i></td>
									<td><?php echo wp_kses_post( get_artists($post->ID, $post->post_type) )?></td>
								</tr>
								<?php endif ?>
								<?php endif ?>
								<tr>
									<td class="event-icon"><i class="fa fa-calendar"></i></td>
									<td><?php echo get_the_date(); ?></td>
								</tr>

								<?php $iron_soundrise_event_show_time = Iron_soundrise::getField( 'event_show_time', $post->ID );
								if( !empty( $iron_soundrise_event_show_time ) ){ ?>
								<tr>
									<td class="event-icon"><i class="fa fa-clock-o"></i></td>
									<td><?php echo esc_html( get_the_time() ) ?></td>
								</tr>
								<?php } ?>

								<?php
								$iron_soundrise_event_city = Iron_soundrise::getField( 'event_city', $post->ID );
								if ( !empty( $iron_soundrise_event_city ) ) {
								?>
								<tr>
									<td class="event-icon"><i class="fa fa-globe"></i></td>
									<td><?php echo esc_html(Iron_soundrise::getField( 'event_city', $post->ID )); ?></td>
								</tr>
								<?php } ?>

								<?php
								$iron_soundrise_event_venue = Iron_soundrise::getField( 'event_venue', $post->ID );
								if(!empty( $iron_soundrise_event_venue )): ?>
								<tr>
									<td class="event-icon"><i class="fa fa-arrow-down"></i></td>
									<td><?php echo esc_html( Iron_soundrise::getField( 'event_venue', $post->ID ) ); ?></td>
								</tr>
								<?php endif; ?>
								<?php
								$iron_soundrise_event_map = Iron_soundrise::getField( 'event_map', $post->ID );
								if(!empty( $iron_soundrise_event_map )): ?>
								<tr>
									<td class="event-icon"><i class="fa fa-map-marker"></i></td>
									<td><a class="event-map-link" href="<?php echo esc_url( Iron_soundrise::getField( 'event_map', $post->ID )); ?>" target="_blank"><?php echo esc_html( Iron_soundrise::getField( 'event_map_label', $post->ID ) ) ?></a></td>
								</tr>
								<?php endif; ?>
							</table>
							<?php $iron_soundrise_iftickets = Iron_soundrise::getField( 'event_link', $post->ID );?>
							<?php if(!empty($iron_soundrise_iftickets)): ?>

							<a class="button" target="_blank" href="<?php echo esc_url($iron_soundrise_iftickets); ?>"><?php echo esc_html( Iron_soundrise::getField( 'event_action_label', $post->ID) ) ?></a>
							<?php endif; ?>
							<?php the_content(); ?>
						</div>
						<div class="clear"></div>
					</div>

					<?php wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'soundrise' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) ); ?>
				</div>
			</article>

			<?php	get_template_part('parts/share'); ?>
			<?php	comments_template(); ?>

<?php
		if ( $iron_soundrise_has_sidebar ) :
?>
				</div>

				<aside id="sidebar" class="sr_it-content-side widget-area widget-area--<?php echo esc_attr( $iron_soundrise_sidebar_area ); ?>">
<?php
	do_action('before_ironband_sidebar_dynamic_sidebar', 'single-event.php');

	dynamic_sidebar( $iron_soundrise_sidebar_area );

	do_action('after_ironband_sidebar_dynamic_sidebar', 'single-event.php');
?>
				</aside>
			</div>
<?php
		endif;
?>

<?php
			endwhile;
		endif;
		?>

		</div>
		</div>

<?php get_footer(); ?>